package com.example.sefinsa_app.ui.historial;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.R;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Grupo;
import com.example.sefinsa_app.models.Modalidad;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.Prestamo;
import com.example.sefinsa_app.models.Reporte;
import com.example.sefinsa_app.models.ReporteHistorial;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.ui.reporte.ReporteFragment;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.ReporteAdapter;
import com.example.sefinsa_app.utilities.ReporteHistorialAdapter;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.material.textfield.TextInputEditText;
import com.google.android.material.textfield.TextInputLayout;
import com.google.gson.Gson;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;

public class HistorialPagosFragment extends Fragment {
    private ArrayList<ReporteHistorial> reportes, reportesFiltrados, reportesFiltradosNombres;
    private VolleyS vs;
    private RequestQueue requestQueue;

    private RecyclerView recyclerView;
    private ReporteHistorialAdapter reporteHistorialAdapter;
    private LinearLayoutManager linearLayoutManager;

    private RutaController rutaController;
    private PoblacionController poblacionController;

    private TextView tvRuta, tvPoblacion, tvColumnaPagado, tvColumnaCobranza;

    private AutoCompleteTextView modalidadesAutoCompleteTextView, rutasAutoCompleteTextView,
            poblacionesAutoCompleteTextView, estatusAutoCompleteTextView;

    private TextInputLayout tlGrupos, tlNombre;

    private String modalidad_id = "1", ruta_id = "", poblacion_id = "", grupo = "", estatus = "", busquedaTexto="";
    private static TextInputEditText svPrestamos;
    private int previousLength;
    private boolean backSpace;

    private ArrayList<Ruta> rutas;
    private ArrayAdapter<Ruta> rutasAdapter;

    private ArrayList<Grupo> grupos;

    private ArrayList<Poblacion> poblaciones;
    private ArrayAdapter<Poblacion> poblacionesAdapter;

    private ArrayList<Modalidad> modalidades;
    private ArrayAdapter<Modalidad> modalidadesAdapter;

    private int totalPagados = 0;
    private int totalCobranza = 0;
    private Map<Integer, String> detallesSemanas;
    private TableLayout headerTable;
    private SharedPreferences sesion;
    public static HistorialPagosFragment newInstance() {
        return new HistorialPagosFragment();
    }

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {
        setHasOptionsMenu(true);
        return inflater.inflate(R.layout.fragment_historial_pagos, container, false);
    }

    @Override
    public void onCreateOptionsMenu(@NonNull Menu menu, @NonNull MenuInflater inflater) {
        super.onCreateOptionsMenu(menu, inflater);
    }

    @Override
    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        switch (item.getItemId()) {
            case R.id.action_refresh:
                requestQueue.getCache().clear();
                getReporteHistorial("1", null, null, null, null);
                return true;
            default:
                return super.onOptionsItemSelected(item);
        }
    }

    @Override
    public void onViewStateRestored(@Nullable Bundle savedInstanceState) {
        super.onViewStateRestored(savedInstanceState);
        modalidadesAutoCompleteTextView.setText(modalidadesAutoCompleteTextView.getAdapter().getItem(0).toString(), false);
        if(rutasAutoCompleteTextView != null)
            rutasAutoCompleteTextView.setText("");
        if(poblacionesAutoCompleteTextView != null)
            poblacionesAutoCompleteTextView.setText("");
        if(tlGrupos != null)
            tlGrupos.getEditText().setText("");
        if (svPrestamos != null)
            svPrestamos.setText("");

    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        CurrentFragment.fragment = "HistorialPagosFragment";

        rutasAutoCompleteTextView = view.findViewById(R.id.acRutaH);
        poblacionesAutoCompleteTextView= view.findViewById(R.id.acPoblacionH);
        modalidadesAutoCompleteTextView = view.findViewById(R.id.acModalidadH);
        headerTable = view.findViewById(R.id.headerTable);
        svPrestamos = view.findViewById(R.id.tvNombre);
        sesion = getActivity().getSharedPreferences("sesion", Context.MODE_PRIVATE);
        tlGrupos = view.findViewById(R.id.tlGruposH);
        estatusAutoCompleteTextView = view.findViewById(R.id.acEstatusH);
        initElements(view);

        linearLayoutManager = new LinearLayoutManager(getContext());
        recyclerView.setLayoutManager(linearLayoutManager);
        reporteHistorialAdapter= new ReporteHistorialAdapter(getActivity(), reportes);
        recyclerView.setAdapter(reporteHistorialAdapter);
        recyclerView.getRecycledViewPool().setMaxRecycledViews(0, 0);
        getEstatus();
        getReporteHistorial("1", null, null, null, null);
    }
    private void getEstatus() {
        // Crear una lista de opciones para el AutoCompleteTextView
        String[] estatusOptions = {};
        if (sesion.getString("nombre_perfil", "").equals("COBRADOR") || sesion.getString("nombre_perfil", "").equals("GESTOR"))
        {
            estatusOptions = new String[]{"Vigente", "Vencido"};
        } else if (sesion.getString("nombre_perfil", "").equals("JURIDICO")) {
            estatusOptions = new String[]{"Vigente", "Vencido", "Pagado", "Renovado", "Jurídico"};
        } else
        {
            estatusOptions = new String[]{"Vigente"};
        }

        // Crear el adaptador con la lista de opciones
        ArrayAdapter<String> estatusAdapter = new ArrayAdapter<>(getContext(), android.R.layout.simple_dropdown_item_1line, estatusOptions);

        // Establecer el adaptador al AutoCompleteTextView
        estatusAutoCompleteTextView.setAdapter(estatusAdapter); // Usamos estatusAutoCompleteTextView correctamente

        // Opcional: escuchar el evento de selección
        estatusAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                // Cuando se selecciona un estatus
                String selectedEstatus = (String) parent.getItemAtPosition(position);

                // Puedes realizar alguna acción con el estatus seleccionado
                // Por ejemplo, convertirlo a un código de estatus (por ejemplo, "Vencido" -> -1)
                estatus = ""; // Valor predeterminado
                switch (selectedEstatus) {
                    case "Vigente":
                        estatus = "0";
                        break;
                    case "Vencido":
                        estatus = "-1";
                        break;
                    case "Pagado":
                        estatus = "1";
                        break;
                    case "Renovado":
                        estatus = "2";
                        break;
                    case "Jurídico":
                        estatus = "4";
                        break;
                }

                filtrarReporte(modalidad_id, ruta_id, poblacion_id, estatus, grupo, busquedaTexto);
            }
        });
        estatusAutoCompleteTextView.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                previousLength = s.length();
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            @Override
            public void afterTextChanged(Editable s) {
                backSpace = previousLength > s.length();

                if (backSpace && !ruta_id.equals("")) {

                    filtrarReporte(modalidad_id, ruta_id, poblacion_id, estatus, grupo, busquedaTexto);

                }

            }
        });
    }
    private void filtrarSoloPorNombre(String text) {

        reportesFiltrados = new ArrayList<>();
        reportesFiltrados.clear();

            reportesFiltradosNombres = new ArrayList<>();

            for (ReporteHistorial reporte : reportesFiltrados) {
                String texto_filtro = reporte.getNombre_completo();
                if (reporte.getTarjeton().toLowerCase().contains(text.toLowerCase()) || reporte.getNombre_completo().toLowerCase().contains(text.toLowerCase()) || texto_filtro.toLowerCase().contains(text.toLowerCase())) {
                    reportesFiltradosNombres.add(reporte);
                }
            }

            if (!reportesFiltradosNombres.isEmpty()) {
                reporteHistorialAdapter.setListaFiltrada(reportesFiltradosNombres);
            }


    }
    public void initElements(View view){

        rutaController = new RutaController(getActivity());
        poblacionController = new PoblacionController(getActivity());
        reportes = new ArrayList<ReporteHistorial>();
        detallesSemanas = new HashMap<>();
        recyclerView = view.findViewById(R.id.rvHistorialPago);
        svPrestamos.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            @Override
            public void afterTextChanged(Editable editable) {
                busquedaTexto = editable.toString();
                Log.d("TextoBusqueda", "Texto ingresado: " + busquedaTexto);
                Log.d("TextoBusqueda", "modalidad_id ingresado: " + modalidad_id);
                Log.d("TextoBusqueda", "ruta_id ingresado: " + ruta_id);
                Log.d("TextoBusqueda", "poblacion_id ingresado: " + poblacion_id);
                Log.d("TextoBusqueda", "estatus ingresado: " + estatus);
                Log.d("TextoBusqueda", "grupo ingresado: " + grupo);

                // Lógica de los filtros
                if (!Objects.equals(modalidad_id, "") && !Objects.equals(ruta_id, "") && !Objects.equals(poblacion_id, "") && !Objects.equals(estatus, "") && !Objects.equals(grupo, "")) {
                    Log.d("Filtrar", "Entrando en la condición: Todos los filtros tienen valores");
                    filtrarReporte(modalidad_id, ruta_id, poblacion_id, estatus, grupo, busquedaTexto); // Todos los filtros
                } else if (!Objects.equals(modalidad_id, "") && !Objects.equals(ruta_id, "") && !Objects.equals(poblacion_id, "") && !Objects.equals(estatus, "")) {
                    Log.d("Filtrar", "Entrando en la condición: Todos los filtros tienen valores MENOS GRUPO");
                    filtrarReporte(modalidad_id, ruta_id, poblacion_id, estatus, "", busquedaTexto); // Sin grupo
                } else if (!Objects.equals(modalidad_id, "") && !Objects.equals(ruta_id, "") && !Objects.equals(poblacion_id, "") && Objects.equals(estatus, "")) {
                    Log.d("Filtrar", "Entrando en la condición: Todos los filtros tienen valores MENOS ESTATUS");
                    filtrarReporte(modalidad_id, ruta_id, poblacion_id, "", "", busquedaTexto); // Sin estatus
                } else if (!Objects.equals(modalidad_id, "") && !Objects.equals(ruta_id, "") && Objects.equals(poblacion_id, "") && Objects.equals(estatus, "")) {
                    Log.d("Filtrar", "Entrando en la condición: Todos los filtros tienen valores MENOS ESTATUS Y POBLACION");
                    filtrarReporte(modalidad_id, ruta_id, "", "", "", busquedaTexto); // Sin estatus y sin población
                } else if (!Objects.equals(modalidad_id, "") && Objects.equals(ruta_id, "") && Objects.equals(poblacion_id, "") && Objects.equals(estatus, "")) {
                    Log.d("Filtrar", "Entrando en la condición: Todos los filtros tienen valores MENOS ESTATUS, POBLACION Y RUTA");
                    filtrarReporte(modalidad_id, "", "", "", "", busquedaTexto); // Sin ruta, población y estatus
                }

                else
                {
                    Log.d("Filtrar", "Entrando en la condición: SIN FILTROS");
                    filtrarSoloPorNombre(busquedaTexto);
                }

            }
        });
        /**
         *  MODALIDADES ADAPTER PARA AUTOCOMPLETTEXTVIEW
         */
        modalidades = new ArrayList<Modalidad>();
        getModalidades();

        modalidadesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {

            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                detallesSemanas = new HashMap<>();
                Modalidad modalidad = modalidadesAdapter.getItem(i);
                modalidad_id = modalidad.getId();

                estatus = "";
                estatusAutoCompleteTextView.setText("");

                ruta_id = "";
                rutasAutoCompleteTextView.setText("");

                poblacion_id = "";
                poblacionesAutoCompleteTextView.setText("");

                grupo = "";
                tlGrupos.getEditText().setText("");

                getReporteHistorial(modalidad_id, null, null, null, null);
            }

        });

        modalidadesAutoCompleteTextView.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                previousLength = s.length();
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            @Override
            public void afterTextChanged(Editable s) {
                backSpace = previousLength > s.length();

                if (backSpace && !modalidad_id.equals("")) {
                    detallesSemanas = new HashMap<>(); // Reinicia el mapa para evitar errores

                    modalidad_id = "";
                    modalidadesAutoCompleteTextView.setText("");

                    ruta_id = "";
                    rutasAutoCompleteTextView.setText("");

                    poblacion_id = "";
                    poblacionesAutoCompleteTextView.setText("");

                    grupo = "";
                    tlGrupos.getEditText().setText("");

                    estatus = "";
                    estatusAutoCompleteTextView.setText("");

                    getReporteHistorial("1", null, null, null, null);

                }

            }
        });


        /**
         *  RUTAS ADAPTER PARA AUTOCOMPLETTEXTVIEW
         */
        rutas = new ArrayList<Ruta>();
        poblaciones = new ArrayList<Poblacion>();
        grupos = new ArrayList<Grupo>();

        getRutas();

        rutasAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {

            @RequiresApi(api = Build.VERSION_CODES.N)
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Ruta ruta = rutasAdapter.getItem(i);
                ruta_id = ruta.getId();
                Log.d("getRutas", "Ruta ID de la rutasAutoCompleteTextView: " + ruta_id);
                if(poblacionesAutoCompleteTextView.getText().toString().length() > 0){
                    poblacionesAutoCompleteTextView.setText("");
                }
                if(tlGrupos.getEditText().getText().toString().length() > 0){
                    tlGrupos.getEditText().setText("");
                }

                List<Poblacion> poblacionesFiltro =
                        poblaciones.stream().filter(poblacion -> poblacion.getRuta_id().equals(ruta_id)).collect(Collectors.toList());

                poblacionesAdapter = new ArrayAdapter<Poblacion>(getContext(), android.R.layout.simple_dropdown_item_1line, poblacionesFiltro);
                poblacionesAutoCompleteTextView.setThreshold(1);
                poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);

                filtrarReporte(modalidad_id, ruta_id, poblacion_id, estatus, grupo, busquedaTexto);

            }
        });

        rutasAutoCompleteTextView.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                previousLength = s.length();
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            @Override
            public void afterTextChanged(Editable s) {
                backSpace = previousLength > s.length();

                if (backSpace && !ruta_id.equals("")) {

                    ruta_id = "";
                    rutasAutoCompleteTextView.setText("");

                    poblacion_id = "";
                    poblacionesAutoCompleteTextView.setText("");

                    grupo = "";
                    tlGrupos.getEditText().setText("");

                    estatus = "";
                    estatusAutoCompleteTextView.setText("");

                    filtrarReporte(modalidad_id, ruta_id, poblacion_id, estatus, grupo, busquedaTexto);

                }

            }
        });

        /**
         *  POBLACIONES ADAPTER PARA AUTOCOMPLETTEXTVIEW
         */

        if(poblaciones.size() == 0){
            getPoblaciones(ruta_id);
        }

        poblacionesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @RequiresApi(api = Build.VERSION_CODES.N)
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Poblacion poblacion = poblacionesAdapter.getItem(i);
                poblacion_id = poblacion.getId();

                filtrarReporte(modalidad_id, ruta_id, poblacion_id, estatus, grupo, busquedaTexto);
            }
        });

        poblacionesAutoCompleteTextView.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                previousLength = s.length();
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            @Override
            public void afterTextChanged(Editable s) {
                backSpace = previousLength > s.length();

                if (backSpace && !poblacion_id.equals("")) {

                    poblacion_id = "";
                    poblacionesAutoCompleteTextView.setText("");

                    estatus = "";
                    estatusAutoCompleteTextView.setText("");

                    grupo = "";
                    tlGrupos.getEditText().setText("");

                    filtrarReporte(modalidad_id, ruta_id, poblacion_id, estatus, grupo, busquedaTexto);

                }

            }
        });


        tlGrupos.getEditText().addTextChangedListener(new TextWatcher() {

            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                previousLength = s.length();
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                // No es necesario hacer nada en esta función en este caso
            }

            @Override
            public void afterTextChanged(Editable s) {
                // Obtener el texto de svPrestamos solo una vez, fuera de la condición
                String textoPrestamos = svPrestamos.getText().toString();

                // Detectamos si el usuario presionó la tecla de retroceso (backspace)
                backSpace = previousLength > s.length();

                if (backSpace) {
                    // Si se presionó backspace, limpiamos los filtros
                    grupo = "";
                    tlGrupos.getEditText().setText("");  // Limpiamos el campo de grupo

                    // Aplicamos el filtro con los valores limpios
                    filtrarReporte(modalidad_id, ruta_id, poblacion_id, estatus, textoPrestamos, grupo);

                } else {
                    if (s.length() > 0) {
                        // Si hay texto en el campo grupo, lo asignamos
                        grupo = s.toString();

                        // Aplicamos el filtro con el nuevo valor de grupo
                        filtrarReporte(modalidad_id, ruta_id, poblacion_id, estatus, textoPrestamos, grupo);
                    }
                }
            }
        });


    }

    private void getModalidades()
    {

        Modalidad modalidad15 = new Modalidad();
        modalidad15.setId("1");
        modalidad15.setCantidad("15");
        Modalidad modalidad20 = new Modalidad();
        modalidad20.setId("2");
        modalidad20.setCantidad("20");
        modalidades.add(modalidad15);
        modalidades.add(modalidad20);

        modalidadesAdapter = new ArrayAdapter<Modalidad>(getContext(), android.R.layout.simple_dropdown_item_1line, modalidades);
        modalidadesAutoCompleteTextView.setThreshold(1);
        modalidadesAutoCompleteTextView.setAdapter(modalidadesAdapter);

    }

    public void getRutas()
    {
        String rutaIdSesion = sesion.getString("rutas", "");
        Log.d("getRutas", "Ruta ID de la sesión: " + rutaIdSesion);

        // Descomponer los IDs de la sesión en una lista
        List<String> rutaIdsSesion = Arrays.asList(rutaIdSesion.split(","));
        Log.d("getRutas", "Ruta IDs de la sesión descompuestos: " + rutaIdsSesion);

        if(rutaController.obtener().size() == 0){

            vs = VolleyS.getInstance(this.getContext());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "rutasActivas");

            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlRutas, data,
                    new Response.Listener<JSONObject>() {

                        @Override
                        public void onResponse(JSONObject response) {
                            try {

                                JSONArray data = (JSONArray) response.get("data");

                                for(int i = 0; i < data.length(); i++){

                                    JSONObject obj = data.getJSONObject(i);

                                    Gson gson = new Gson();
                                    Ruta ruta = gson.fromJson(obj.toString(), Ruta.class);

                                    if (rutaIdsSesion.contains(ruta.getId())) {
                                        rutas.add(ruta);
                                        rutaController.nueva(ruta);
                                        Log.d("getRutas", "Ruta añadida: " + ruta.toString());
                                    }

                                }

                                rutasAdapter = new ArrayAdapter<Ruta>(getContext(), android.R.layout.simple_dropdown_item_1line, rutas);
                                rutasAutoCompleteTextView.setThreshold(1);
                                rutasAutoCompleteTextView.setAdapter(rutasAdapter);

                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {

                @Override
                public void onErrorResponse(VolleyError error) {

                    ErrorChecker.checker(error, getActivity());

                }

            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    0,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);

        }
        else{
            Log.d("getRutas", "Recuperando rutas guardadas localmente.");
            List<Ruta> rutasGuardadas = rutaController.obtener();
            Log.d("getRutas", "Cantidad de rutas locales encontradas: " + rutasGuardadas.size());

            for (Ruta ruta : rutasGuardadas) {
                Log.d("getRutas", "Ruta local encontrada: " + ruta.toString());
                // Verificar si el ID de la ruta está en la lista de IDs de la sesión
                if (rutaIdsSesion.contains(ruta.getId())) {
                    rutas.add(ruta);
                    Log.d("getRutas", "Ruta añadida tras filtrar: " + ruta);
                }
            }

            rutasAdapter = new ArrayAdapter<Ruta>(getContext(), android.R.layout.simple_dropdown_item_1line, rutas);
            rutasAutoCompleteTextView.setThreshold(1);
            rutasAutoCompleteTextView.setAdapter(rutasAdapter);
        }

    }

    private void getPoblaciones(String ruta_id)
    {
        if(poblacionController.obtener().size() == 0) {

            vs = VolleyS.getInstance(this.getContext());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "index");

            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPoblaciones, data,
                    new Response.Listener<JSONObject>() {

                        @Override
                        public void onResponse(JSONObject response) {
                            try {

                                JSONArray data = (JSONArray) response.get("data");

                                for (int i = 0; i < data.length(); i++) {

                                    JSONObject obj = data.getJSONObject(i);

                                    Gson gson = new Gson();
                                    Poblacion poblacion = gson.fromJson(obj.toString(), Poblacion.class);

                                    poblaciones.add(poblacion);
                                    poblacionController.nueva(poblacion);

                                }

                                poblacionesAdapter = new ArrayAdapter<Poblacion>(getContext(), android.R.layout.simple_dropdown_item_1line, poblaciones);
                                poblacionesAutoCompleteTextView.setThreshold(1);
                                poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);

                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {

                @Override
                public void onErrorResponse(VolleyError error) {

                    ErrorChecker.checker(error, getActivity());

                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    0,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);
        }
        else{

            poblaciones = poblacionController.obtener();

            poblacionesAdapter = new ArrayAdapter<Poblacion>(getContext(), android.R.layout.simple_dropdown_item_1line, poblaciones);
            poblacionesAutoCompleteTextView.setThreshold(1);
            poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);

        }
    }


    private void getReporteHistorial(String modalidad_id, String ruta_id, String poblacion_id, String grupo, String estatus) {
        ProgressDialog dialog = new ProgressDialog(getActivity(), R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        headerTable.removeAllViews();
        headerTable.invalidate();
        Log.d("filtrarReporte", "modalidad_id: " + modalidad_id);
        // Luego de obtener los datos, actualiza el adaptador con la modalidad seleccionada
        reporteHistorialAdapter.actualizarModalidad(modalidad_id);

        // Actualiza los datos del RecyclerView (o lo que corresponda)
        reporteHistorialAdapter.notifyDataSetChanged();


        ExecutorService executor = Executors.newSingleThreadExecutor(); // Para ejecutar en segundo plano
        executor.execute(() -> {
            DatabaseHelper dbHelper = new DatabaseHelper(requireActivity());
            SQLiteDatabase db = dbHelper.getReadableDatabase();

            reportes.clear();

            // Construcción del WHERE dinámico
            StringBuilder whereClause = new StringBuilder();
            whereClause.append("WHERE cs.id = ").append(modalidad_id).append(" ");

            if (ruta_id != null && !ruta_id.isEmpty()) {
                whereClause.append("AND clientes.ruta_id = ").append(ruta_id).append(" ");
            }
            if (poblacion_id != null && !poblacion_id.isEmpty()) {
                whereClause.append("AND clientes.poblacion_id = ").append(poblacion_id).append(" ");
            }
            if (grupo != null && !grupo.isEmpty()) {
                whereClause.append("AND prestamos.grupo_poblacion = ").append(grupo).append(" ");
            }
            if (estatus != null) {
                if (estatus.equals("3")) {
                    whereClause.append("AND prestamos.status != ").append(estatus).append(" ");
                } else {
                    whereClause.append("AND prestamos.status = ").append(estatus).append(" ");
                }
            }

            // Construcción dinámica de las columnas por semanas
            int numeroSemanas = Integer.parseInt((modalidad_id.equals("1")) ? "15" : "20");
            StringBuilder columnasSemanas = new StringBuilder();

            for (int i = 1; i <= numeroSemanas; i++) {
                columnasSemanas.append("MAX(CASE WHEN pagos.semana = ")
                        .append(i)
                        .append(" THEN pagos.fecha_pago || '<br>' || ")
                        .append("CASE ")
                        .append("WHEN pagos.status = 3 THEN 'Pago con multa' ")
                        .append("WHEN pagos.status = 1 THEN 'Pago a tiempo' ")
                        .append("WHEN pagos.status = -1 THEN 'No pagó' ")
                        .append("WHEN pagos.status = 2 THEN 'Pago omitido' ")
                        .append("WHEN pagos.status = 0 THEN 'Pago vigente' ")
                        .append("ELSE '' END || '<br>' || ")
                        .append("CASE WHEN pagos.folio != '0' THEN pagos.folio ELSE '' END || '<br>' || ")  // Omitir folio 0
                        .append("CASE WHEN pagos.cantidad_pendiente != '0.00' THEN '$' || pagos.cantidad_pendiente ELSE '' END || '<br>' || ")
                        .append("pagos.tipo_pago END) AS semana")
                        .append(i)
                        .append(", ");
            }


            // Eliminar la última coma y espacio extra
            if (columnasSemanas.length() > 0) {
                columnasSemanas.setLength(columnasSemanas.length() - 2);
            }

            // Construcción de la consulta principal
            String query = "SELECT prestamos.numero_tarjeton, clientes.nombre_completo, clientes.ruta_id,clientes.poblacion_id, clientes.direccion, clientes.telefono, " +
                    "clientes.garantias, avales.nombre_completo AS nombre_aval, avales.direccion AS direccion_aval, " +
                    "avales.telefono AS telefono_aval, prestamos.monto_prestado, prestamos.pago_semanal, pagos.prestamo_id, " +
                    "prestamos.modalidad_semanas, prestamos.status, prestamos.grupo_poblacion, pagos.status AS pago_status, poblaciones.nombre_poblacion AS nombre_poblacion, " +
                    "(prestamos.pago_semanal * cs.cantidad) AS balance_original, " +
                    "((prestamos.pago_semanal * cs.cantidad) - SUM(CASE WHEN pagos.status = 2 THEN pagos.cantidad_esperada_pago ELSE pagos.cantidad_normal_pagada END)) AS balance, " +
                    columnasSemanas.toString() + " " +
                    "FROM prestamos " +
                    "JOIN clientes ON clientes.id = prestamos.cliente_id " +
                    "LEFT JOIN avales ON avales.id = prestamos.aval_id " +
                    "LEFT JOIN pagos ON pagos.prestamo_id = prestamos.id " +
                    "LEFT JOIN poblaciones ON poblaciones.id = clientes.poblacion_id " +
                    "INNER JOIN configuracion_semanas AS cs ON prestamos.modalidad_semanas = cs.id " +
                    whereClause.toString() +
                    "GROUP BY prestamos.id, clientes.poblacion_id " +
                    "ORDER BY clientes.poblacion_id DESC";

            Cursor cursor = db.rawQuery(query, null);

            if (cursor != null && cursor.moveToFirst()) {
                do {
                    ReporteHistorial reporte = new ReporteHistorial();
                    reporte.setTarjeton(cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton")));
                    reporte.setNombre_completo(cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")));
                    reporte.setMonto_prestado(cursor.getString(cursor.getColumnIndexOrThrow("monto_prestado")));
                    reporte.setPago_semanal(cursor.getString(cursor.getColumnIndexOrThrow("pago_semanal")));
                    reporte.setPrestamo_id(cursor.getString(cursor.getColumnIndexOrThrow("prestamo_id")));
                    reporte.setModalidad_semanas(cursor.getString(cursor.getColumnIndexOrThrow("modalidad_semanas")));
                    reporte.setStatus(cursor.getString(cursor.getColumnIndexOrThrow("status")));
                    reporte.setBalance_original(cursor.getString(cursor.getColumnIndexOrThrow("balance_original")));
                    reporte.setRuta_id(cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")));
                    reporte.setPoblacion_id(cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")));
                    reporte.setNombre_poblacion(cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion")));
                    reporte.setGrupo(cursor.getString(cursor.getColumnIndexOrThrow("grupo_poblacion")));
                    // Agregar lógica para los campos dinámicos (semana1, semana2, etc.)
                    for (int i = 1; i <= numeroSemanas; i++) {
                        String columnaSemana = "semana" + i;
                        reporte.setDetalleSemana(i, cursor.getString(cursor.getColumnIndexOrThrow(columnaSemana)));
                        reporte.setPago_status(cursor.getString(cursor.getColumnIndexOrThrow("pago_status")));
                    }
                    reportes.add(reporte);
                } while (cursor.moveToNext());
                cursor.close();
            }
            db.close();
            executor.shutdown();

            // Actualización en la UI
            getActivity().runOnUiThread(() -> {
                TableRow headerRow = new TableRow(requireActivity());

                // Encabezados fijos
                String[] headers = {"Tarjeton", "Poblacion", "Cliente", "Monto", "Pago"};
                float[] weights = {1f, 1.8f, 2.8f, 1.5f, 2f};

                // Añadir los encabezados fijos
                for (int i = 0; i < headers.length; i++) {
                    TextView tvHeader = new TextView(requireActivity());
                    tvHeader.setText(headers[i]);
                    tvHeader.setGravity(Gravity.CENTER);
                    tvHeader.setTextSize(14);
                    tvHeader.setTypeface(Typeface.DEFAULT_BOLD);
                    tvHeader.setPadding(10, 10, 10, 0);
                    tvHeader.setBackgroundColor(ContextCompat.getColor(requireActivity(), R.color.white));

                    TableRow.LayoutParams params = new TableRow.LayoutParams(0, TableRow.LayoutParams.WRAP_CONTENT, weights[i]);
                    tvHeader.setLayoutParams(params);

                    headerRow.addView(tvHeader);
                }

                int numSemanas = Integer.parseInt((modalidad_id.equals("1")) ? "15" : "20");

                // Añadir dinámicamente las semanas al encabezado
                for (int i = 1; i <= numSemanas; i++) {
                    TextView tvSemana = new TextView(requireActivity());
                    tvSemana.setText("Semana " + i);
                    tvSemana.setGravity(Gravity.CENTER);
                    tvSemana.setTextSize(14);
                    tvSemana.setTypeface(Typeface.DEFAULT_BOLD);
                    tvSemana.setPadding(10, 10, 10, 0);
                    tvSemana.setBackgroundColor(ContextCompat.getColor(requireActivity(), R.color.white));

                    // Configurar LayoutParams con peso uniforme para las semanas
                    TableRow.LayoutParams params = new TableRow.LayoutParams(0, TableRow.LayoutParams.WRAP_CONTENT, 1.4f);
                    params.setMargins(10, 0, 0, 0);  // Márgenes opcionales para separación
                    tvSemana.setLayoutParams(params);

                    headerRow.addView(tvSemana);
                }

                // Agregar la fila completa de encabezados al TableLayout
                headerTable.addView(headerRow);

                dialog.cancel();
                reporteHistorialAdapter.addAll(reportes);
                reporteHistorialAdapter.notifyItemRangeChanged(0, reportes.size());
            });
        });
    }

    /*
    private void getReporteEstimado(String modalidad_id, String ruta_id, String poblacion_id, String grupo)
    {
        ProgressDialog dialog = new ProgressDialog(getActivity(),  R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        vs = VolleyS.getInstance(getActivity());
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "reporteEstimadoApp");
            data.put("modalidad", modalidad_id);
            data.put("ruta", ruta_id);
            data.put("poblacion", poblacion_id);
            data.put("grupo", grupo);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        Log.d("SEND", data.toString());

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {

                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            dialog.cancel();
                            //String data = response.get("data").toString();
                            JSONArray data = (JSONArray) response.get("data");

                            Log.d("DATA", data.toString());

                            totalPagados = 0;
                            totalCobranza = 0;
                            reporteAdapter.clear();
                            reportes.clear();

                            for(int i = 0; i < data.length(); i++){
                                JSONObject obj = data.getJSONObject(i);
                                Gson gson = new Gson();
                                Reporte reporte = gson.fromJson(obj.toString(), Reporte.class);
                                totalPagados += Integer.parseInt(reporte.getCantidad_pagados());
                                totalCobranza += Integer.parseInt(reporte.getCantidad_no_pagados());
                                reportes.add(reporte);
                                Log.d("getReporteEstimado", "Actualizando el adaptador, reportes: " + reportes.toString());
                            }
                            Log.d("getReporteEstimado", "Actualizando el adaptador, reportes: " + reportes.size());
                            tvColumnaPagado.setText("PAGADO \n ("+totalPagados+")");
                            tvColumnaCobranza.setText("COBRANZA \n ("+totalCobranza+")");

                            reporteAdapter.addAll(reportes);
                            reporteAdapter.notifyItemRangeChanged(reportes.size(), 1);

                            recyclerView.setVisibility(View.VISIBLE);
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {
                dialog.cancel();
                ErrorChecker.checker(error, getActivity());
            }
        }) ;

        request.setRetryPolicy(new DefaultRetryPolicy(
                5000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setShouldCache(false);
        requestQueue.add(request);

    }
    */
    private void filtrarReporte(String modalidad_id, String ruta_id, String poblacion_id, String status, String grupo, String busqueda) {
        // Limpiar la lista filtrada antes de comenzar
        reportesFiltrados = new ArrayList<>();
        reportesFiltrados.clear();

        for (ReporteHistorial reporte : reportes) {
            // Comparaciones seguras para evitar NullPointerException
            boolean modalidadCoincide = (modalidad_id == null || modalidad_id.isEmpty() || modalidad_id.equals(reporte.getModalidad_semanas()));
            boolean rutaCoincide = (ruta_id == null || ruta_id.isEmpty() || ruta_id.equals(reporte.getRuta_id()));
            boolean poblacionCoincide = (poblacion_id == null || poblacion_id.isEmpty() || poblacion_id.equals(reporte.getPoblacion_id()));
            boolean grupoCoincide = (grupo == null || grupo.isEmpty() || grupo.equals(reporte.getGrupo()));
            boolean statusCoincide = (status == null || status.isEmpty() || status.equals(reporte.getStatus()));

            // Comparación para el campo de búsqueda (nombre completo o tarjetón)
            String textoFiltro = reporte.getNombre_completo() + "\nTarjeton: " + reporte.getTarjeton();
            boolean busquedaCoincide = (busqueda == null || busqueda.isEmpty() ||
                    reporte.getNombre_completo().toLowerCase().contains(busqueda.toLowerCase()) ||
                    textoFiltro.toLowerCase().contains(busqueda.toLowerCase()));

            // Condición final: todas las condiciones deben cumplirse
            if (modalidadCoincide && rutaCoincide && poblacionCoincide && grupoCoincide && statusCoincide && busquedaCoincide) {
                reportesFiltrados.add(reporte);
            }
        }

        // Actualizar el adaptador con los resultados
        if (!reportesFiltrados.isEmpty()) {
            reporteHistorialAdapter.setListaFiltrada(reportesFiltrados);
        } else {
            reporteHistorialAdapter.setListaFiltrada(new ArrayList<>());
            Log.d("filtrarReporte", "No se encontraron coincidencias.");
        }
    }


    // Método para convertir enteros de forma segura
    private int safeParseInt(String value) {
        try {
            return value != null ? Integer.parseInt(value) : 0;
        } catch (NumberFormatException e) {
            return 0;
        }
    }


}